/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Unlimited Scan 
/* - Contents: α׷ A/D CH0 CH4 ä Unlimited scan
/*     ̿Ͽ A/D convert ϰ   CH0 ͸ Ͽ 
/*      ̴.  Լ ĵ ۸  Access ʰ,
/*     COMICX_US1_RetrvChannel () Ͽ ͸ Ѵ.
/* - Remarks : 
/*     1.   COMI-ST101 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMICX_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "ComidasCX.h"

#define DEV_ID	COMI_ST101
#define NUM_CH	2	/* Number of channels */
#define S_FREQ	1000	/* Scan freq. -> 1000 Hz */
#define MSB		40960	/* Max scans/buffer =>   scan  ũ⸦ ϴµ  */
						/* 1024  ϴ° .                           */
#define CH_BUF_SIZE	(S_FREQ * 2) 
                      
void main (void)
{
	HANDLE hDevice;
	int ch_list[2] = {0, 4};  /* Scan channel list : 0  4 ä */
	FILE *fp;
	float *pChanBuf;
	ULONG prv_cnt=0, count;
	ULONG i;

	/* Load DLL */
	if(!COMICX_LoadDll()){
		printf("ComidasLX.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}
	/* Load Device */
	hDevice = COMICX_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMICX_UnloadDll();
		exit(0);
	}

	// Ʒ COMICX_AD_SetInputType() Լ COMI-ST201//
	//  Ǵ ԼԴϴ. COMI-ST201带 ϴ//
	// 쿡 Ʒ Լ ּ Ͻʽÿ.            //
	// Analog Input type 'Single ended' Ѵ. //
	// Differential Է ϰ Ѵٸ AI_SINGLEſ  //
	// AI_DIFF  Ͽ Ѵ.                          //

	//COMICX_AD_SetInputType (hDevice, AI_SINGLE);
	
	// Set A/D range //
	COMICX_AD_SetRange(hDevice, 0, -10, 10);
	COMICX_AD_SetRange(hDevice, 4, -10, 10);
	
	printf("A/D Scan Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();

	/* start unlimited scan */
	long act_freq = COMICX_US1_Start (hDevice, NUM_CH, ch_list, S_FREQ, MSB, TRS_SINGLE);
	if(act_freq < 0){
		/* Error ó */
		printf("Error : Failed to start unlimited scan!");
		printf("%s", COMICX_ErrorString (COMICX_LastError())); 
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMICX_UnloadDevice(hDevice);
		COMICX_UnloadDll();
		exit(0);
	}

	/* Create a file to save data */
	/* Create a file to save data */
	if((fp = fopen ("c:\\ComiUscan.txt", "w")) == NULL){
		printf("͸     ϴ.\nƹŰ  ˴ϴ.\n");
		_getch();
		COMICX_US1_Stop (hDevice, TRUE);
		COMICX_UnloadDevice(hDevice);
		COMICX_UnloadDll();
	}
	fprintf (fp,"   CH0\n");
	// Allocate a buffer to retrieve scan data //
	if((pChanBuf = (float *)malloc(sizeof(float)*CH_BUF_SIZE)) == NULL){
		printf("Memory allocation failed !");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMICX_US1_Stop (hDevice, TRUE);
		COMICX_UnloadDevice(hDevice);
		COMICX_UnloadDll();
		exit(0);
	}
	prv_cnt = 0;
	while(!kbhit())
	{
		// CH0 SCAN͸ ´.							      //
		// prv_cnt Ŀ scan ͼ CH_BUF_SIZE     //
		//  scan ͱ ۿ ְ CH_BUF_SIZE  ũ   //
		// CH_BUF_SIZE ŭ ش.                               //
		count = COMICX_US1_RetrvChannel (hDevice, 0, prv_cnt+1, CH_BUF_SIZE, pChanBuf, VT_FLOAT);
		for(i=0; i<count; i++)
			fprintf (fp, "%6.2f\n", pChanBuf[i]);
		prv_cnt += count;
		printf("Number of saved data = %d\n", prv_cnt);
		Sleep(100);
	}
	
	free(pChanBuf); // Free channel buffer 
	COMICX_US1_Stop (hDevice, TRUE);
	fclose(fp);

	COMICX_UnloadDevice(hDevice);
	COMICX_UnloadDll();
}
